/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import java.util.function.Function;
import lib.toma.animations.AnimationEngine;
import lib.toma.animations.api.AnimationStage;
import lib.toma.animations.api.IAnimateCallback;
import lib.toma.animations.api.IAnimationEntry;
import lib.toma.animations.api.IAnimationPipeline;
import lib.toma.animations.api.IAnimator;
import lib.toma.animations.api.IHandAnimator;
import lib.toma.animations.api.IHandRenderAPI;
import lib.toma.animations.api.IHandRenderer;
import lib.toma.animations.api.IHandTransformer;
import lib.toma.animations.api.IItemRenderer;
import lib.toma.animations.api.IRenderConfig;
import lib.toma.animations.api.IRenderPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public final class MainRenderPipeline
implements IRenderPipeline {
    private IAnimator animator = this::animate;
    private IHandAnimator handAnimator = this::animateHands;
    private IHandRenderer handRenderer = this::renderHand;
    private IItemRenderer itemRenderer = this::renderItem;
    private IAnimateCallback preAnimate = this::empty_callback;
    private IAnimateCallback postAnimate = this::empty_callback;

    @Override
    public void register(IEventBus bus) {
        bus.addListener(this::onHandRender);
    }

    @Override
    public void setAnimator(IAnimator animator) {
        this.animator = Objects.requireNonNull(animator);
    }

    @Override
    public void setHandAnimator(IHandAnimator animator) {
        this.handAnimator = Objects.requireNonNull(animator);
    }

    @Override
    public void setHandRenderer(IHandRenderer handRenderer) {
        this.handRenderer = Objects.requireNonNull(handRenderer);
    }

    @Override
    public void setItemRenderer(IItemRenderer itemRenderer) {
        this.itemRenderer = Objects.requireNonNull(itemRenderer);
    }

    @Override
    public void setPreAnimateCallback(IAnimateCallback callback) {
        this.preAnimate = Objects.requireNonNull(callback);
    }

    @Override
    public void setPostAnimateCallback(IAnimateCallback callback) {
        this.postAnimate = Objects.requireNonNull(callback);
    }

    @Override
    public IAnimator getAnimator() {
        return this.animator;
    }

    @Override
    public IHandAnimator getHandAnimator() {
        return this.handAnimator;
    }

    @Override
    public IHandRenderer getHandRenderer() {
        return this.handRenderer;
    }

    @Override
    public IItemRenderer getItemRenderer() {
        return this.itemRenderer;
    }

    private void onHandRender(RenderHandEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof IAnimationEntry) {
            AnimationEngine engine = AnimationEngine.get();
            IHandRenderAPI handSetup = engine.getHandRenderAPI();
            IAnimationEntry animatedRender = (IAnimationEntry)stack.func_77973_b();
            IAnimationPipeline pipeline = engine.pipeline();
            boolean isDeveloperMode = handSetup.isDevMode();
            IHandTransformer transformer = isDeveloperMode ? handSetup : animatedRender;
            Function<HandSide, IRenderConfig> configForHand = hand -> hand == HandSide.RIGHT ? transformer.right() : transformer.left();
            event.setCanceled(true);
            Minecraft mc = Minecraft.func_71410_x();
            FirstPersonRenderer fpRenderer = mc.func_175597_ag();
            boolean mainhand = event.getHand() == Hand.MAIN_HAND;
            ItemCameraTransforms.TransformType transformType = mainhand ? ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
            boolean disableVanillaAnimations = animatedRender.disableVanillaAnimations();
            float equipProgress = disableVanillaAnimations ? 0.0f : event.getEquipProgress();
            float swingProgress = disableVanillaAnimations ? 0.0f : event.getSwingProgress();
            MatrixStack poseStack = event.getMatrixStack();
            IRenderTypeBuffer buffer = event.getBuffers();
            int light = event.getLight();
            this.animator.animate(poseStack, buffer, light, swingProgress, equipProgress, configForHand, pipeline, fpRenderer, (PlayerEntity)mc.field_71439_g, stack, transformType, mainhand);
        }
    }

    private void animate(MatrixStack poseStack, IRenderTypeBuffer buffer, int light, float swing, float equip, Function<HandSide, IRenderConfig> selector, IAnimationPipeline pipeline, FirstPersonRenderer fpRenderer, PlayerEntity player, ItemStack stack, ItemCameraTransforms.TransformType type, boolean mainHand) {
        this.preAnimate.call(poseStack, buffer, light, swing, equip, selector, pipeline, fpRenderer, player, stack, type, mainHand);
        poseStack.func_227860_a_();
        pipeline.animateStage(AnimationStage.ITEM_AND_HANDS, poseStack, buffer, light, OverlayTexture.field_229196_a_);
        poseStack.func_227860_a_();
        pipeline.animateStage(AnimationStage.HANDS, poseStack, buffer, light, OverlayTexture.field_229196_a_);
        this.handAnimator.animateHands(poseStack, buffer, light, equip, selector, pipeline);
        poseStack.func_227865_b_();
        pipeline.animateStage(AnimationStage.HELD_ITEM, poseStack, buffer, light, OverlayTexture.field_229196_a_);
        this.itemRenderer.renderItem(fpRenderer, player, stack, type, !mainHand, poseStack, buffer, light, swing, equip);
        poseStack.func_227865_b_();
        this.postAnimate.call(poseStack, buffer, light, swing, equip, selector, pipeline, fpRenderer, player, stack, type, mainHand);
    }

    private void animateHands(MatrixStack poseStack, IRenderTypeBuffer buffer, int light, float equip, Function<HandSide, IRenderConfig> selector, IAnimationPipeline pipeline) {
        float offsetY = -0.5f * equip;
        RenderSystem.disableCull();
        poseStack.func_227860_a_();
        poseStack.func_227861_a_(0.0, (double)offsetY, 0.0);
        poseStack.func_227860_a_();
        pipeline.animateStage(AnimationStage.RIGHT_HAND, poseStack, buffer, light, OverlayTexture.field_229196_a_);
        this.handRenderer.renderHand(poseStack, HandSide.RIGHT, selector, buffer, light);
        poseStack.func_227865_b_();
        poseStack.func_227860_a_();
        pipeline.animateStage(AnimationStage.LEFT_HAND, poseStack, buffer, light, OverlayTexture.field_229196_a_);
        this.handRenderer.renderHand(poseStack, HandSide.LEFT, selector, buffer, light);
        poseStack.func_227865_b_();
        poseStack.func_227865_b_();
    }

    private void renderHand(MatrixStack stack, HandSide side, Function<HandSide, IRenderConfig> selector, IRenderTypeBuffer buffer, int light) {
        boolean rightArm = side == HandSide.RIGHT;
        IRenderConfig config = selector.apply(side);
        config.applyTo(stack);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(mc.field_71439_g.func_110306_p());
        EntityRenderer renderer = mc.func_175598_ae().func_78713_a((Entity)mc.field_71439_g);
        PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
        stack.func_227860_a_();
        stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(40.0f));
        stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-90.0f));
        if (rightArm) {
            stack.func_227861_a_((double)0.8f, (double)-0.3f, (double)-0.4f);
            playerRenderer.func_229144_a_(stack, buffer, light, (AbstractClientPlayerEntity)mc.field_71439_g);
        } else {
            stack.func_227861_a_(-0.5, (double)0.6f, (double)-0.36f);
            playerRenderer.func_229146_b_(stack, buffer, light, (AbstractClientPlayerEntity)mc.field_71439_g);
        }
        stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(-41.0f));
        stack.func_227865_b_();
    }

    private void renderItem(FirstPersonRenderer fpRenderer, PlayerEntity player, ItemStack stack, ItemCameraTransforms.TransformType type, boolean offHand, MatrixStack poseStack, IRenderTypeBuffer buffer, int light, float swing, float equip) {
        HandSide side = offHand ? HandSide.LEFT : HandSide.RIGHT;
        float swingSqrt = MathHelper.func_76129_c((float)swing);
        float swingX = -0.4f * MathHelper.func_76126_a((float)(swingSqrt * (float)Math.PI));
        float swingY = 0.2f * MathHelper.func_76126_a((float)(swingSqrt * ((float)Math.PI * 2)));
        float swingZ = -0.2f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
        int xMultiplier = !offHand ? 1 : -1;
        poseStack.func_227861_a_((double)((float)xMultiplier * swingX), (double)swingY, (double)swingZ);
        int multiplier = side == HandSide.RIGHT ? 1 : -1;
        poseStack.func_227861_a_((double)((float)multiplier * 0.56f), (double)(-0.52f + equip * -0.6f), (double)-0.72f);
        if (swing != 0.0f) {
            float attackSwingY = MathHelper.func_76126_a((float)(swing * swing * (float)Math.PI));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)multiplier * (45.0f + attackSwingY * -20.0f)));
            float attackSwingXZ = MathHelper.func_76126_a((float)(swingSqrt * (float)Math.PI));
            poseStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_((float)multiplier * attackSwingXZ * -20.0f));
            poseStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(attackSwingXZ * -80.0f));
            poseStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)multiplier * -45.0f));
        }
        fpRenderer.func_228397_a_((LivingEntity)player, stack, type, offHand, poseStack, buffer, light);
    }

    private void empty_callback(MatrixStack poseStack, IRenderTypeBuffer buffer, int light, float swing, float equip, Function<HandSide, IRenderConfig> selector, IAnimationPipeline pipeline, FirstPersonRenderer fpRenderer, PlayerEntity player, ItemStack stack, ItemCameraTransforms.TransformType type, boolean mainHand) {
    }
}

